package org.msh.tb.reports2.variables;

import org.msh.reports.keys.Key;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.entities.enums.HIVResult;
import org.msh.tb.reports2.VariableImpl;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 19/12/16.
 */
public class HIVReportVariable extends VariableImpl {

    public static final String HIV_CASES = "hiv_cases";
    public static final String HIV_POSITIVE = "hiv_positive";

    public enum HIVKey {
        KNOWN,
        POSITIVE,
        NEGATIVE,
        UNKNOW,
        POSITIVE_CPT,
        POSITIVE_ART
    }

    public HIVReportVariable() {
        super("hiv-report", "manag.reportgen.var.hivreport", null);
    }

    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        def.select("hivresult");
        def.select("if(isnull(startedARTdate), 0, 1)");
        def.select("if(isnull(startedCPTdate), 0, 1)");
    }

    @Override
    public Key createKey(Object values, int iteration) {
        Object[] vals = (Object[])values;
        Integer index = (Integer)vals[0];
        Integer startedART = (Integer)vals[1];
        Integer startedCPT = (Integer)vals[1];

        List<Key> keys = new ArrayList<Key>();

        HIVResult hivResult = index != null ? HIVResult.values()[index] : null;
        if (hivResult != HIVResult.POSITIVE) {
            keys.add(Key.of(HIV_CASES, hivResult == HIVResult.NEGATIVE ?
                    HIVKey.NEGATIVE :
                    HIVKey.UNKNOW));
        } else {
            keys.add(Key.of(HIV_CASES, HIVKey.POSITIVE));

            if (startedART == 1) {
                keys.add(Key.of(HIV_POSITIVE, HIVKey.POSITIVE_ART));
            }

            if (startedCPT == 1) {
                keys.add(Key.of(HIV_POSITIVE, HIVKey.POSITIVE_CPT));
            }
        }

        if (hivResult == HIVResult.POSITIVE || hivResult == HIVResult.NEGATIVE) {
            keys.add(Key.of(HIV_CASES, HIVKey.KNOWN));
        }

        return Key.asMultipleArray(keys.toArray());
    }

    @Override
    public int compareValues(Key key1, Key key2) {
        HIVKey val1 = (HIVKey)key1.getValue();
        HIVKey val2 = (HIVKey)key2.getValue();

        return val1.compareTo(val2);
    }

    @Override
    public String getDisplayText(Key key) {
        HIVKey val = (HIVKey)key.getValue();

        switch (val) {
            case KNOWN: return "Known";
            case NEGATIVE: return "Negative";
            case POSITIVE: return "Positive";
            case UNKNOW: return "Unknown";
            case POSITIVE_ART: return "on ART";
            case POSITIVE_CPT: return "on CPT";
            default: return "-";
        }
    }

    @Override
    public boolean isTotalEnabled() {
        return false;
    }

    @Override
    public boolean isGrouped() {
        return false;
    }

    @Override
    public String getGroupDisplayText(Key key) {
        if (HIV_POSITIVE.equals(key.getGroup())) {
            return "HIV positive";
        }

        return "Cases";
    }
}
